clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

%% COSTANTI FISICHE
T0=273;         % Temperatura assoluta rif. [K]
T=293;          % Temperatura assoluta [K]
mu=1.81e-5;     % viscosit` dinamica dell'aria a 0 C [Pas]
R=287.053;      % Costante dell'aria [J/Kg/K]
Pa=1e5;         % Pressione ambiente a 273 K [Pa]
Ps=7e5;
b_c=0.5283;

Kt=sqrt(T/T0);
rho=Pa/(R*T);   % Densità dell'aria in condizioni normali [kg/m^3]
psi=0.6855/sqrt(R*T);
cost=1/(24*mu*R*T);

ck=60000/rho;   % per passare da l/min a kg/s
g=9.806;
dt=1e-7;        % parametro per la soluzione statica


%% GEOMETRIA PATTINO
n_fori=4;
dp=1e-3;        % foro ingresso pattino
hg=30e-6;       % profondità media ragnatura
wg=0.2e-3;      % larghezza ragnatura
L=60e-3;
B=30e-3;
l=45e-3;
b=20e-3;
lx=(L-l)/2;
ly=(B-b)/2;
coeff=1;
A=L*B*coeff;            % Aumentando coeff gira più veloce (equivale ad aumentare il passo di tempo)
Vg=wg*hg*2*(l+b);     % volume ragnatura

% h_des=8;

%% PARAMETRI DELLA VALVOLA
d_ratio=0.5;
dn=dp*d_ratio;                      % Nozzle diameter
dm=6e-3;                            % diametro membrana metallica m
x_bypass=13;   %    [um]

xn=-5.504783654428411e-06;
km=4.001772878379899e+05;



d_con=5e-3;             % diametro condotti interni al pattino
V_valvola=(6e-3-3.75e-3)^2*pi/4*3.9e-3+(1.875e-3)^2*pi/4*(9)*1e-3;  % V valvola
V_cond=pi*d_con^2/4*(60+30)*1e-3;
V_cavo=pi*(4e-3)^2/4*20e-3;
V1=V_valvola+V_cond+V_cavo;         % volume tra valvola e pattino
S_eqv=(l*b+L*B+0.5*(L*b+B*l))/3;        % superficie equivalente su cui insiste la Fp considerando una distribuz. di pressione a tronco di piramide

%% PARAMETRI TEMPO DIPENDENTI
%Reynolds Conduttanze 
   RRe1t=[];
   RRe2t=[];
   Cd1t=[];
   Cd2t=[];
   Cs1t=[];
   Cs2t=[];
   %Pressioni
   P1t=[];
   P2t=[];
   P0t=[];
% Caratteristiche pattino + valvola 
   H0t=[];
   H_dott=[];
   Xvt=[];
   G1t=[];
   G2t=[];
   G3t=[];
   Fmt=[];
   time=[];
   FFextt=[];

%% CALCOLO DEL PRIMO PUNTO DI FUNZIONAMENTO
h0=8*1e-6;
%% INIZIALIZZAZIONE PARAMETRI DEL MODELLO
p1=Ps; % [Pa]
p2=Ps;
p0=Ps;
Re1=0;
Re2=0;
Fp0=0;
err_Fp=10;
j=0;
toll=1e-10;

V0=h0*l*b;      % volume del meato
V2=V0+Vg;       % volume tot. = volume meato + volume ragnatura

tic

while (abs(err_Fp)>toll)
j=j+1;

% Calcolo la distanza ugello-membrana
x=xn+(p1-Pa)*pi*dm^2/4/km;

% Verifico se sono in condizioni di x_bypass o meno
if x<x_bypass*1e-6
   x=x_bypass*1e-6;
end

% Calcolo la conduttanza dell'ugello della valvola (considero la sezione ANULARE)
cd1=1.05*(1-0.3*exp(-0.005*Re1));
cs1=cd1*(pi*x*dn)*Kt*psi;      % conduttanza dell'ugello della valvola con sezione ANULARE

% Calcolo la portata dell'ugello della valvola g1
[g1]=FORO(cs1,Ps,p1);        % portata attraverso l'ugello della valvola calcolata con la function FORO 
Re1=abs(g1)/(pi*mu*dn);

% Calcolo la conduttanza del foro del pattino (considero la sezione ANULARE)
cd2=1.05*(1-0.3*exp(-0.005*Re2));
cs2=cd2*(pi*h0*dp+2*wg*hg)*Kt*psi;   % conduttanza di un foro del pattino
[g2]=FORO(cs2,p1,p2);             % portata attraverso un foro del pattino
heq=(pi*h0*dp+2*hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

% Portate in uscita dal pattino
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);  

% Calcolo le pressioni p1, p0 e p2
p1=p1+(g1-g2*n_fori)*dt*R*T/V1;       % applico Eulero esplicito in avanti
p0=p0+(g2*n_fori-g3)*dt*R*T/V2;       % applico Eulero esplicito in avanti
af=0.14;bf=5e-6;
f=1-af^(bf/h0);        % f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;   % formula inversa per trovare p2

% Calcolo la forza di pressione Fp dovuta al meato
Fp=S_eqv*(p0-Pa);

% calcolo gli errori per uscire dal while
err_Fp=(Fp-Fp0)/Fp;
            
Fp0=Fp;
end
    toc
    
%% CALCOLO DEGLI ALTRI PUNTI DI FUNZIONAMENTO NOTO IL CARICO IMPOSTO
F_EXT=[Fp:-40:40];

%% PLOT
LIN=readmatrix("Coefficienti K LIN.xls");
NL=readmatrix("Coefficienti K NL.xls");

figure (1)
plot(F_EXT,NL(1,:),'r'), hold on
plot(F_EXT,LIN(1,:),'k'), hold off
figure (2)
plot(F_EXT,NL(2,:),'r'), hold on
plot(F_EXT,LIN(2,:),'k'), hold off
figure (3)
plot(F_EXT,NL(3,:),'r'), hold on
plot(F_EXT,LIN(3,:),'k'), hold off
figure (4)
plot(F_EXT,NL(4,:),'r'), hold on
plot(F_EXT,LIN(4,:),'k'), hold off
figure (5)
plot(F_EXT,NL(5,:),'r'), hold on
plot(F_EXT,LIN(5,:),'k'), hold off
figure (6)
plot(F_EXT,NL(6,:),'r'), hold on
plot(F_EXT,LIN(6,:),'k'), hold off
figure (7)
plot(F_EXT,NL(7,:),'r'), hold on
plot(F_EXT,LIN(7,:),'k'), hold off
figure (8)                          %ok
plot(F_EXT,NL(8,:),'r'), hold on
plot(F_EXT,LIN(8,:),'k'), hold off
figure (9)                          %ok
plot(F_EXT,NL(9,:),'r'), hold on
plot(F_EXT,LIN(9,:),'k'), hold off
figure (10)
plot(F_EXT,NL(10,:),'r'), hold on
plot(F_EXT,LIN(10,:),'k'), hold off
figure (11)
plot(F_EXT,NL(11,:),'r'), hold on
plot(F_EXT,LIN(11,:),'k'), hold off
figure (12)
plot(F_EXT,NL(12,:),'r'), hold on
plot(F_EXT,LIN(12,:),'k'), hold off
figure (13)                         %ok
plot(F_EXT,NL(13,:),'r'), hold on
plot(F_EXT,LIN(13,:),'k'), hold off
